/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Random;

public final class Math {
    private static Random rand;
    public static final double E = 2.718281828459045;
    public static final double PI = 3.141592653589793;

    private Math() {
    }

    public static int abs(int i) {
        if (i < 0) {
            return -i;
        }
        return i;
    }

    public static long abs(long l) {
        if (l < 0L) {
            return -l;
        }
        return l;
    }

    public static float abs(float f) {
        if (f <= 0.0f) {
            return 0.0f - f;
        }
        return f;
    }

    public static double abs(double d) {
        if (d <= 0.0) {
            return 0.0 - d;
        }
        return d;
    }

    public static int min(int a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    public static long min(long a, long b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    public static float min(float a, float b) {
        if (a != a) {
            return a;
        }
        if (a == 0.0f && b == 0.0f) {
            return -(-a - b);
        }
        if (a < b) {
            return a;
        }
        return b;
    }

    public static double min(double a, double b) {
        if (a != a) {
            return a;
        }
        if (a == 0.0 && b == 0.0) {
            return -(-a - b);
        }
        if (a < b) {
            return a;
        }
        return b;
    }

    public static int max(int a, int b) {
        if (a > b) {
            return a;
        }
        return b;
    }

    public static long max(long a, long b) {
        if (a > b) {
            return a;
        }
        return b;
    }

    public static float max(float a, float b) {
        if (a != a) {
            return a;
        }
        if (a == 0.0f && b == 0.0f) {
            return a - -b;
        }
        if (a > b) {
            return a;
        }
        return b;
    }

    public static double max(double a, double b) {
        if (a != a) {
            return a;
        }
        if (a == 0.0 && b == 0.0) {
            return a - -b;
        }
        if (a > b) {
            return a;
        }
        return b;
    }

    public static native double sin(double var0);

    public static native double cos(double var0);

    public static native double tan(double var0);

    public static native double asin(double var0);

    public static native double acos(double var0);

    public static native double atan(double var0);

    public static native double atan2(double var0, double var2);

    public static native double exp(double var0);

    public static native double log(double var0);

    public static native double sqrt(double var0);

    public static native double pow(double var0, double var2);

    public static native double IEEEremainder(double var0, double var2);

    public static native double ceil(double var0);

    public static native double floor(double var0);

    public static native double rint(double var0);

    public static int round(float a) {
        if (a != a) {
            return 0;
        }
        return (int)Math.floor(a + 0.5f);
    }

    public static long round(double a) {
        if (a != a) {
            return 0L;
        }
        return (long)Math.floor(a + 0.5);
    }

    public static synchronized double random() {
        if (rand == null) {
            rand = new Random();
        }
        return rand.nextDouble();
    }

    public static double toRadians(double degrees) {
        return degrees * Math.PI / 180.0;
    }

    public static double toDegrees(double rads) {
        return rads * 180.0 / Math.PI;
    }
}

